use "$data\apisfile", clear
global dataset apis
set seed 2038947

**Setting the bandwidth
local b = 5

**Setting the number of re-samples
local S = 1000

**Matrix for the output
**(1) AT (2) C (3) C2 (4) IV (5) NT 
matrix OUTPUT = J(`S',5,.)

g phicmem_d_after=phicmem*D_after

foreach var in lnpchealth phicmem D_after phicmem_d_after {
	reg `var' D i.year X1 i.D#c.(X1) flagexp if inrange(X1, -`b', `b'-1)
	predict r_`var', resid
}


reg r_lnpchealth r_phicmem r_D_after r_phicmem_d_after if inrange(X1, -`b', `b'-1), cluster(hhid)
test r_phicmem_d_after
local p = round(r(p),0.001)

forvalues s = 1/`S' {
 
	di `s'
	
	use "$data\apisfile", clear
	keep if inrange(X1, - `b' , `b' -1)
	
	g phicmem_d_after=phicmem*D_after

	foreach var in lnpchealth phicmem D_after phicmem_d_after {
		reg `var' D i.year X1 i.D#c.(X1) flagexp if inrange(X1, -`b', `b'-1)
		predict r_`var', resid
	}

	bsample  
 
	**Computing the first stage probabilities
	reg phicmem i.D##year i.D##c.X1 flagexp if inrange(X1, - `b' , `b' -1), cluster(hhid)
	scalar diff = _b[1.D#2016.year]
	predict p0 if (X1 <= -1 & X1 >= -1) & yr==1
	sum p0
	local p0 =  r(mean)
	

	
	**Estimating the DiD regression
	reg r_lnpchealth r_phicmem r_D_after r_phicmem_d_after if inrange(X1, -`b', `b'-1), cluster(hhid)
	scalar phi0 = _b[_cons]
	scalar phi1 = _b[r_phicmem]
	scalar phi2 = _b[r_D_after]
	scalar phi3 = _b[r_phicmem_d_after]
	
	scalar alpha_U = 2*phi2/diff
	scalar alpha_T = 2*(phi2 + phi3)/diff
	scalar mu_U = phi0 - (`p0'*phi2)/diff
	scalar mu_T = phi0 +phi1 - (phi2 + phi3)*(`p0'-1)/diff
	
	scalar AT = mu_T - mu_U + (alpha_T-alpha_U)*(`p0'/2) - 1/2*(alpha_T-alpha_U)
	matrix OUTPUT[`s',1] = AT
	scalar C = mu_T - mu_U + (alpha_T-alpha_U)*(2*`p0'+diff)/2 - 1/2*(alpha_T-alpha_U)
	matrix OUTPUT[`s',2] = C
	scalar C2 = mu_T - mu_U
	matrix OUTPUT[`s',3] = C2
	scalar NT = mu_T - mu_U + (alpha_T-alpha_U)*((1+`p0'+diff)/2) - 1/2*(alpha_T-alpha_U)
	matrix OUTPUT[`s',5] = NT

	**IV regression
	*ivreg2 lnpchealth (phicmem = D_after) D i.year c.(X1) i.D#c.(X1) flagexp if inrange(X1, -`b', `b'-1) , cluster(hhid)
	ivreg2 r_lnpchealth (r_phicmem = r_D_after)  if inrange(X1, -`b', `b'-1) , cluster(hhid)
	matrix OUTPUT[`s',4] = _b[r_phicmem]
	*display `p0'
	*display diff
	*matrix list OUTPUT
	*STOP

}

svmat OUTPUT
rename OUTPUT1 AT
rename OUTPUT2 C
rename OUTPUT3 Mu_diff
rename OUTPUT4 IV
rename OUTPUT5 NT

**95% CI 
cap drop Q2_5 Q97_5 Mean xvar *_q
gen Q2_5 = .
gen Q97_5 = .
gen Mean = .
gen xvar = .
local j = 1

foreach var in AT C IV NT {

	sum `var'
	replace Mean = r(mean) in `j'
	
	egen `var'_q = xtile(`var'), n(1000)
	sum `var' if `var'_q == 25
	local q2_5 = r(mean)
	replace Q2_5 = `q2_5' in `j' 
	
	sum `var' if `var'_q == 975
	local q97_5 = r(mean)
	replace Q97_5 = `q97_5' in `j' 
	
	replace xvar = `j' in `j'
	local ++j

}

twoway (scatter Mean xvar) (rspike Q2_5 Q97_5 xvar), /// 
	ytitle(Treatment Effect) xtitle(" ") ///
	xlabel(1 `""Always" "Takers""' 2 "Compliers" 3 "IV" 4 `""Never" "Takers""') ///
	legend(off) scheme(s2mono) graphregion(color(white))
	
graph export "$figs\/${dataset}_boxplot_mte_95CI.png", as(png) replace width(5000) 
	